/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.client.render.umbrella;

import com.github.mim1q.convenientdecor.block.UmbrellaBlock;
import com.github.mim1q.convenientdecor.block.blockentity.UmbrellaBlockEntity;
import com.github.mim1q.convenientdecor.client.render.umbrella.UmbrellaRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class UmbrellaBlockEntityRenderer
implements BlockEntityRenderer<UmbrellaBlockEntity> {
    private final UmbrellaRenderer.UmbrellaRenderHelper umbrellaRenderers;

    public UmbrellaBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.umbrellaRenderers = new UmbrellaRenderer.UmbrellaRenderHelper(ctx.m_173585_());
    }

    public void render(UmbrellaBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockState state = entity.m_58900_();
        UmbrellaBlock block = (UmbrellaBlock)state.m_60734_();
        boolean folded = entity.folded;
        int blockRotation = (Integer)state.m_61143_((Property)UmbrellaBlock.ROTATION);
        float rotation = (float)blockRotation * 22.5f;
        boolean leaning = (Boolean)state.m_61143_((Property)UmbrellaBlock.LEANING);
        if (leaning) {
            rotation = (float)((blockRotation + 2) % 16 / 4) * 90.0f;
        }
        matrices.m_85836_();
        matrices.m_252880_(0.5f, 0.05f, 0.5f);
        matrices.m_252781_(new Quaternionf().rotateY((float)Math.PI / 180 * (-rotation + 90.0f)));
        if (leaning) {
            matrices.m_252781_(new Quaternionf().rotateZ((float)Math.PI / 180 * (folded ? 30.0f : 10.0f)));
            matrices.m_252880_(folded ? 0.3f : 0.65f, folded ? -0.3f : -0.2f, 0.0f);
            matrices.m_252781_(new Quaternionf().rotateY(1.5707964f));
        } else {
            matrices.m_252781_(new Quaternionf().rotateZ((float)Math.PI / 180 * (folded ? 100.0f : 55.0f)));
            matrices.m_252880_(0.25f, folded ? -0.6f : -0.5f, 0.0f);
            matrices.m_252781_(new Quaternionf().rotateY(0.5235988f));
        }
        this.umbrellaRenderers.getRenderer(state).render(matrices, vertexConsumers, light, overlay, block.color, folded);
        matrices.m_85849_();
    }
}

